<?php

namespace App\Filament\Admin\Widgets;

use App\Models\Venta;
use App\Models\DetalleVenta;
use Filament\Widgets\ChartWidget;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Illuminate\Support\Facades\DB;

class CategorySalesChart extends ChartWidget
{
    use InteractsWithPageFilters;

    protected static ?string $heading = 'Ventas por Categoría';
    protected static ?int $sort = 3;
    protected int | string | array $columnSpan = 1;

    protected function getData(): array
    {
        $desde = $this->filters['desde'] ?? now()->subDays(30)->format('Y-m-d');
        $hasta = $this->filters['hasta'] ?? now()->format('Y-m-d');

        $data = DB::table('detalles_ventas')
            ->join('productos', 'detalles_ventas.producto_id', '=', 'productos.id')
            ->join('categorias', 'productos.categoria_id', '=', 'categorias.id')
            ->select('categorias.nombre', DB::raw('SUM(detalles_ventas.subtotal) as total'))
            ->whereDate('detalles_ventas.created_at', '>=', $desde)
            ->whereDate('detalles_ventas.created_at', '<=', $hasta)
            ->groupBy('categorias.nombre')
            ->get();

        return [
            'datasets' => [
                [
                    'label' => 'Ventas por Categoría',
                    'data' => $data->pluck('total'),
                    'backgroundColor' => ['#6366f1', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6'],
                ],
            ],
            'labels' => $data->pluck('nombre'),
        ];
    }

    protected function getType(): string
    {
        return 'doughnut';
    }
}