<?php

namespace App\Filament\Admin\Widgets;

use App\Models\Producto;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class LowStockWidget extends BaseWidget
{
    protected static ?string $heading = '⚠️ Alerta de Stock Crítico';
    protected static ?int $sort = 5;
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                Producto::query()->whereColumn('stock', '<=', 'stock_minimo')
            )
            ->columns([
                Tables\Columns\TextColumn::make('nombre')
                    ->label('PRODUCTO')
                    ->weight('bold'),
                Tables\Columns\TextColumn::make('stock')
                    ->label('STOCK ACTUAL')
                    ->badge()
                    ->color('danger'),
                Tables\Columns\TextColumn::make('stock_minimo')
                    ->label('STOCK MÍNIMO')
                    ->color('gray'),
                Tables\Columns\TextColumn::make('categoria.nombre')
                    ->label('CATEGORÍA')
                    ->badge(),
            ])
            ->paginated(false);
    }
}