<?php
namespace App\Filament\Admin\Widgets;
use App\Models\Venta;
use App\Models\Producto;
use Filament\Widgets\ChartWidget;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class SalesChart extends ChartWidget {
    use InteractsWithPageFilters;
    protected static ?string $heading = 'Comparativa de Rendimiento Temporal';
    protected static ?int $sort = 2;
    protected int | string | array $columnSpan = 2;

    protected function getData(): array {
        $desde = $this->filters['desde'] ?? now()->subDays(30)->format('Y-m-d');
        $hasta = $this->filters['hasta'] ?? now()->format('Y-m-d');
        $userId = $this->filters['user_id'] ?? null;
        $productoId = $this->filters['producto_id'] ?? null;

        $getQuery = function($user = null, $prod = null) use ($desde, $hasta) {
            $query = DB::table('ventas');
            if ($prod) {
                $query->join('detalles_ventas', 'ventas.id', '=', 'detalles_ventas.venta_id')
                      ->where('detalles_ventas.producto_id', $prod);
                $sumField = 'detalles_ventas.subtotal';
            } else {
                $sumField = 'ventas.total';
            }
            if ($user) $query->where('ventas.user_id', $user);
            
            return $query->select(DB::raw('DATE(ventas.created_at) as date'), DB::raw("SUM($sumField) as aggregate"))
                         ->whereDate('ventas.created_at', '>=', $desde)
                         ->whereDate('ventas.created_at', '<=', $hasta)
                         ->groupBy('date')->orderBy('date')->get();
        };

        $globalData = $getQuery(null, $productoId);
        $userData = $userId ? $getQuery($userId, $productoId) : collect();

        $datasets = [
            [
                'label' => $productoId ? 'Ventas Globales del Producto' : 'Ventas Globales',
                'data' => $globalData->pluck('aggregate'),
                'borderColor' => '#94a3b8',
                'backgroundColor' => 'rgba(148, 163, 184, 0.1)',
                'fill' => 'start',
            ]
        ];

        if ($userId) {
            $datasets[] = [
                'label' => $productoId ? 'Ventas del Vendedor (Producto)' : 'Ventas del Vendedor',
                'data' => $userData->pluck('aggregate'),
                'borderColor' => '#6366f1',
                'backgroundColor' => 'rgba(99, 102, 241, 0.2)',
                'fill' => 'start',
            ];
        }

        return [
            'datasets' => $datasets,
            'labels' => $globalData->map(fn ($item) => Carbon::parse($item->date)->format('d M')),
        ];
    }

    protected function getType(): string { return 'line'; }
}