<?php

namespace App\Filament\Admin\Widgets;

use App\Models\Producto;
use App\Models\Venta;
use App\Models\User;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class StatsOverview extends BaseWidget
{
    use InteractsWithPageFilters;

    protected static ?int $sort = 1;

    protected function getStats(): array
    {
        $desde = $this->filters['desde'] ?? now()->subDays(30)->format('Y-m-d');
        $hasta = $this->filters['hasta'] ?? now()->format('Y-m-d');
        $userId = $this->filters['user_id'] ?? null;
        $productoId = $this->filters['producto_id'] ?? null;
        $hoy = Carbon::today()->format('Y-m-d');

        $calcTotal = function ($start, $end, $user = null, $prod = null) {
            $query = DB::table('ventas');
            
            if ($prod) {
                $query->join('detalles_ventas', 'ventas.id', '=', 'detalles_ventas.venta_id')
                      ->where('detalles_ventas.producto_id', $prod);
                $sumField = 'detalles_ventas.subtotal';
            } else {
                $sumField = 'ventas.total';
            }

            if ($user) {
                $query->where('ventas.user_id', $user);
            }

            return $query->whereDate('ventas.created_at', '>=', $start)
                         ->whereDate('ventas.created_at', '<=', $end)
                         ->sum($sumField);
        };

        $globalPeriodo = $calcTotal($desde, $hasta, null, $productoId);
        $globalHoy = $calcTotal($hoy, $hoy, null, $productoId);

        $userPeriodo = $userId ? $calcTotal($desde, $hasta, $userId, $productoId) : 0;
        $userHoy = $userId ? $calcTotal($hoy, $hoy, $userId, $productoId) : 0;
        $userName = $userId ? User::find($userId)?->name : "";

        $labelProd = $productoId ? " (" . Producto::find($productoId)?->nombre . ")" : "";

        $descPeriodo = $userId ? "Vendedor ({$userName}): S/. " . number_format($userPeriodo, 2) : "Total recaudado en el rango seleccionado";
        $descHoy = $userId ? "Vendedor ({$userName}): S/. " . number_format($userHoy, 2) : "Total recaudado el día de hoy";

        return [
            Stat::make('Ventas del Periodo' . $labelProd, 'S/. ' . number_format($globalPeriodo, 2))
                ->description($descPeriodo)
                ->descriptionIcon($userId ? 'heroicon-m-user' : 'heroicon-m-calendar-days')
                ->color($userId ? 'info' : 'slate'),

            Stat::make('Ventas de Hoy' . $labelProd, 'S/. ' . number_format($globalHoy, 2))
                ->description($descHoy)
                ->descriptionIcon($userId ? 'heroicon-m-user' : 'heroicon-m-banknotes')
                ->color('success'),

            Stat::make('Stock Crítico', Producto::whereColumn('stock', '<=', 'stock_minimo')->count())
                ->description('Productos por reponer')
                ->descriptionIcon('heroicon-m-exclamation-triangle')
                ->color('danger')
                ->url(\App\Filament\Resources\ProductoResource::getUrl('index', ['activeTab' => 'critico'])),

            Stat::make('Total Catálogo', Producto::count())
                ->description('Medicamentos en sistema')
                ->color('gray'),
        ];
    }
}