<?php

namespace App\Filament\Exports;

use App\Models\Venta;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class VentaExporter extends Exporter
{
    protected static ?string $model = Venta::class;

    public function getFileDisk(): string
    {
        return 'public';
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')->label('ID'),
            ExportColumn::make('created_at')->label('Fecha'),
            ExportColumn::make('usuario.name')->label('Cajero'),
            ExportColumn::make('tipo_documento')->label('Documento'),
            ExportColumn::make('tipo_pago')->label('Pago'),
            ExportColumn::make('total')->label('Total'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'La exportación de ventas ha sido completada y ' . number_format($export->successful_rows) . ' filas han sido procesadas.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' filas fallaron.';
        }

        return $body;
    }
}