<?php
namespace App\Filament\Resources;
use App\Filament\Resources\CategoriaResource\Pages;
use App\Models\Categoria;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\TextColumn;

class CategoriaResource extends Resource {
    protected static ?string $model = Categoria::class;
    protected static ?string $navigationIcon = 'heroicon-o-tag';
    protected static ?string $navigationLabel = 'Categorías';
    protected static ?string $navigationGroup = 'Logística';

    public static function form(Form $form): Form {
        return $form->schema([TextInput::make('nombre')->required()->unique(ignoreRecord:true)]);
    }

    public static function table(Table $table): Table {
        return $table->columns([
            TextColumn::make('nombre')->searchable()->sortable(),
            TextColumn::make('productos_count')->counts('productos')->label('Artículos'),
        ])->actions([Tables\Actions\EditAction::make(), Tables\Actions\DeleteAction::make()]);
    }

    public static function getPages(): array {
        return ['index' => Pages\ListCategorias::route('/'), 'create' => Pages\CreateCategoria::route('/create'), 'edit' => Pages\EditCategoria::route('/{record}/edit')];
    }
}