<?php
namespace App\Filament\Resources;
use App\Filament\Resources\EmpleadoResource\Pages;
use App\Models\Empleado;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\{TextInput, Toggle, Section};
use Filament\Tables\Columns\TextColumn;

class EmpleadoResource extends Resource {
    protected static ?string $model = Empleado::class;
    protected static ?string $navigationIcon = 'heroicon-o-user-group';
    protected static ?string $navigationLabel = 'Personal';
    protected static ?string $navigationGroup = 'Administración';

    public static function form(Form $form): Form {
        return $form->schema([
            Section::make('Datos del Empleado')->schema([
                TextInput::make('dni')->required()->unique(ignoreRecord: true)->length(8),
                TextInput::make('nombres')->required(),
                TextInput::make('apellidos')->required(),
                TextInput::make('telefono')->tel(),
                Toggle::make('activo')->default(true),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table {
        return $table->columns([
            TextColumn::make('dni')->searchable(),
            TextColumn::make('nombres')->searchable(),
            TextColumn::make('apellidos')->searchable(),
            TextColumn::make('telefono'),
            TextColumn::make('activo')->formatStateUsing(fn ($state) => $state ? 'Sí' : 'No'),
        ])->actions([Tables\Actions\EditAction::make(), Tables\Actions\DeleteAction::make()]);
    }

    public static function getPages(): array {
        return ['index' => Pages\ListEmpleados::route('/'), 'create' => Pages\CreateEmpleado::route('/create'), 'edit' => Pages\EditEmpleado::route('/{record}/edit')];
    }
}