<?php
namespace App\Filament\Resources\MovimientoStockResource\Pages;
use App\Filament\Resources\MovimientoStockResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;

class CreateMovimientoStock extends CreateRecord {
    protected static string $resource = MovimientoStockResource::class;
    public function getTitle(): string { return 'Registro de Lote de Mercadería'; }

    protected function handleRecordCreation(array $data): \Illuminate\Database\Eloquent\Model
    {
        $items = $data['items'] ?? [];
        $lastRecord = null;

        foreach ($items as $item) {
            $lastRecord = \App\Models\MovimientoStock::create([
                'tipo' => $data['tipo'],
                'motivo' => $data['motivo'],
                'user_id' => $data['user_id'],
                'producto_id' => $item['producto_id'],
                'cantidad' => $item['cantidad'],
            ]);
        }

        return $lastRecord;
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Movimientos Registrados')
            ->body('El lote de productos ha sido procesado y el stock actualizado correctamente.');
    }

    protected function getRedirectUrl(): string {
        return $this->getResource()::getUrl('index');
    }
}