<?php
namespace App\Filament\Resources\ProductoResource\Pages;
use App\Filament\Resources\ProductoResource;
use Filament\Resources\Pages\EditRecord;
use Filament\Actions;
class EditProducto extends EditRecord {
    protected static string $resource = ProductoResource::class;
    public function getTitle(): string { return 'Editar Registro'; }
    public function getBreadcrumb(): string { return 'Editar'; }
    protected function getHeaderActions(): array {
        return [
            Actions\Action::make('ingresar_stock')
                ->label('Ingresar Stock')
                ->icon('heroicon-m-plus-circle')
                ->color('success')
                ->form([
                    \Filament\Forms\Components\TextInput::make('cantidad')
                        ->label('Cantidad a Ingresar')
                        ->numeric()
                        ->required()
                        ->minValue(1),
                    \Filament\Forms\Components\TextInput::make('motivo')
                        ->label('Motivo / Referencia')
                        ->required()
                        ->default('Ingreso manual de stock'),
                ])
                ->action(function (array $data): void {
                    \App\Models\MovimientoStock::create([
                        'producto_id' => $this->record->id,
                        'user_id' => auth()->id(),
                        'tipo' => 'entrada',
                        'cantidad' => $data['cantidad'],
                        'motivo' => $data['motivo'],
                    ]);

                    \Filament\Notifications\Notification::make()
                        ->title('Stock Actualizado')
                        ->success()
                        ->send();
                    
                    $this->refreshFormData(['stock']);
                }),
            Actions\DeleteAction::make()->label('Eliminar'),
        ];
    }
}