<?php
namespace App\Filament\Resources\ProductoResource\Pages;
use App\Filament\Resources\ProductoResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Components\Tab;

class ListProductos extends ListRecords {
    protected static string $resource = ProductoResource::class;
    public function getTitle(): string { return 'Listado de Inventario'; }
    public function getBreadcrumb(): string { return 'Listado'; }
    protected function getHeaderActions(): array {
        return [
            \Filament\Actions\Action::make('excel')
                ->label('Excel')
                ->icon('heroicon-m-table-cells')
                ->color('success')
                ->url(fn() => route('report.excel', 'productos')),
            \Filament\Actions\Action::make('pdf')
                ->label('PDF')
                ->icon('heroicon-m-document-text')
                ->color('danger')
                ->url(fn() => route('report.pdf', 'productos'))
                ->openUrlInNewTab(),
            Actions\Action::make('ingreso_masivo')
                ->label('Ingreso Masivo (Stock)')
                ->icon('heroicon-m-rectangle-stack')
                ->color('info')
                ->url(\App\Filament\Resources\MovimientoStockResource::getUrl('create')),
            Actions\CreateAction::make()->label('Nuevo Producto'),
        ];
    }

    public function getTabs(): array
    {
        return [
            'todos' => Tab::make('Todos'),
            'critico' => Tab::make('Stock Crítico')
                ->modifyQueryUsing(fn ($query) => $query->whereColumn('stock', '<=', 'stock_minimo'))
                ->icon('heroicon-m-exclamation-triangle')
                ->badge(\App\Models\Producto::whereColumn('stock', '<=', 'stock_minimo')->count()),
        ];
    }
}