<?php
namespace App\Filament\Resources;
use App\Filament\Resources\RoleResource\Pages;
use Spatie\Permission\Models\Role;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\{TextInput, Select};
use Filament\Tables\Columns\TextColumn;

class RoleResource extends Resource {
    protected static ?string $model = Role::class;
    protected static ?string $navigationIcon = 'heroicon-o-shield-check';
    protected static ?string $navigationLabel = 'Roles';
    protected static ?string $navigationGroup = 'Seguridad';

    public static function form(Form $form): Form {
        return $form->schema([
            TextInput::make('name')->required()->unique(ignoreRecord: true)->label('Nombre del Rol'),
            Select::make('permissions')->multiple()->relationship('permissions', 'name')->preload()->label('Permisos'),
        ]);
    }

    public static function table(Table $table): Table {
        return $table->columns([
            TextColumn::make('name')->label('Rol')->searchable(),
            TextColumn::make('permissions_count')->counts('permissions')->label('Permisos')->badge(),
        ])->actions([Tables\Actions\EditAction::make(), Tables\Actions\DeleteAction::make()]);
    }

    public static function getPages(): array {
        return ['index' => Pages\ListRoles::route('/'), 'create' => Pages\CreateRole::route('/create'), 'edit' => Pages\EditRole::route('/{record}/edit')];
    }
}