<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up(): void {
        Schema::create('ventas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users');
            $table->decimal('total', 12, 2)->default(0);
            $table->string('tipo_documento')->default('boleta');
            $table->string('tipo_pago')->default('efectivo');
            $table->decimal('efectivo_recibido', 12, 2)->nullable();
            $table->decimal('vuelto', 12, 2)->default(0);
            $table->string('estado')->default('completada');
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('ventas'); }
};