<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('exports', function (Blueprint $table) {
            if (!Schema::hasColumn('exports', 'processed_rows')) {
                $table->unsignedInteger('processed_rows')->default(0)->after('successful_rows');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exports', function (Blueprint $table) {
            $table->dropColumn('processed_rows');
        });
    }
};