<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder {
    public function run(): void {
        $modules = ['productos', 'categorias', 'ventas', 'empleados', 'usuarios'];
        $actions = ['ver', 'crear', 'editar', 'eliminar'];

        foreach ($modules as $module) {
            foreach ($actions as $action) {
                Permission::firstOrCreate(['name' => "{$action} {$module}"]);
            }
        }

        $adminRole = Role::where('name', 'administrador')->first();
        if ($adminRole) {
            $adminRole->syncPermissions(Permission::all());
        }

        $vendedorRole = Role::where('name', 'vendedor')->first();
        if ($vendedorRole) {
            $vendedorRole->syncPermissions([
                'ver productos', 'ver categorias', 'ver ventas', 'crear ventas'
            ]);
        }
    }
}