<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Acceso Restringido - ChelyFarma</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: "Plus Jakarta Sans", sans-serif; background-color: #f8fafc; }
    </style>
</head>
<body class="antialiased bg-slate-50 flex items-center justify-center min-h-screen p-6">
    <div class="max-w-md w-full text-center space-y-8 bg-white p-10 rounded-3xl shadow-xl border border-slate-100">
        <div class="flex justify-center">
            <div class="bg-indigo-50 p-4 rounded-2xl">
                <svg class="w-16 h-16 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m0 0v3m0-3h3m-3 0H9m12-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 10a3 3 0 016 0v3M9 13h6"></path>
                </svg>
            </div>
        </div>
        <div>
            <h1 class="text-6xl font-black text-slate-900 tracking-tighter mb-2">403</h1>
            <h2 class="text-xl font-bold text-slate-800 uppercase tracking-wider mb-4">Acceso Denegado</h2>
            <p class="text-slate-500 leading-relaxed mb-8">Lo sentimos, no tienes los permisos necesarios para acceder a esta sección de la plataforma ChelyFarma.</p>
            <a href="/admin" class="inline-flex items-center justify-center px-8 py-3 font-bold text-white bg-indigo-600 rounded-2xl hover:bg-indigo-700 transition-all transform hover:scale-105 active:scale-95 shadow-lg shadow-indigo-200">
                Regresar al Inicio
            </a>
        </div>
        <div class="pt-6 border-t border-slate-50">
            <p class="text-xs text-slate-400 font-medium uppercase tracking-widest">Sistema de Gestión ChelyFarma &copy; 2026</p>
        </div>
    </div>
</body>
</html>